﻿/*	VERSION:	1.2
	
USAGE:
	#include "functions/traceContents.as"
	traceContents( myObject );
	
NOTE:
	#include only needs to be used once...
	...because this is a _global function.
*/
_global.traceContents = function( object, indent, depth )
{
	var indent = indent || "  ";
	var depth = depth || 1;
	for(var nam in object)
	{
		var childType = typeof(object[nam]);
		if( object[nam] instanceof Array )
			childType = "array";
		if( object[nam][0] instanceof Array )
			childType = "multi-dimensional array";
		
		if( typeof(object[nam]) =="object")
			trace( indent+nam+" ("+childType+")" );
		else
			trace( indent+nam+":  "+object[nam]+" ("+childType+")" );
		
		
		if(childType == "object"  ||  childType == "array"){
			if(depth < 6){		// max depth to scan
				traceContents( object[nam], indent+"  ", depth+1 );
			}else{
				trace( indent+"  ..." );
			}
		}else if (childType=="multi-dimensional array"){
			trace( indent+"  ..." );
		}
	}// for:  object
}// traceContents()